# WordLift SEO Audit Skill - Setup Guide

**Version**: 1.0.0
**Last Updated**: October 2025

## ✅ What We've Created

A **properly architected Agent Skill** that uses the **WordLift MCP server** for SEO audits with competitive analysis.

**Key Features**:
- ✅ MCP-based architecture (no network access issues)
- ✅ WordLift branded reports with official design system
- ✅ Progressive disclosure pattern (efficient token usage)
- ✅ Versioned and maintainable
- ✅ Complete branding guidelines

### Architecture (Correct Approach)

```
┌─────────────────────────────────────┐
│   Claude (with Agent Skills)       │
│   ├── SKILL.md (v1.0.0)            │  Provides methodology
│   ├── REPORT_FORMAT.md             │  and instructions
│   └── resources/BRANDING.md        │  Brand guidelines
└─────────────────┬───────────────────┘
                  │
                  │ Uses MCP Tools:
                  │ WordLift:agent
                  │ WordLift:graphql
                  │
┌─────────────────▼───────────────────┐
│   WordLift MCP Server               │
│   https://mcp.wordlift.io/sse       │  Makes external
│                                     │  API calls
│   ├── Handles authentication       │
│   ├── Calls WordLift API           │
│   └── Returns structured data      │
└─────────────────────────────────────┘
```

## 📁 Project Structure

```
wl-seo-audit-competitors/
├── SKILL.md                    # Main skill file (v1.0.0) - Claude reads this
├── REPORT_FORMAT.md            # Report formatting guide
├── SETUP.md                    # This setup guide
├── resources/
│   └── BRANDING.md            # WordLift brand guidelines
└── docs/
    └── readme.md              # Complete documentation
```

## 🚀 How to Use

### Step 1: Configure WordLift MCP Server

**In Claude Desktop/Web:**

1. Open Claude Settings
2. Go to **Integrations** section
3. Click **Add more**
4. Enter:
   - **Integration name:** `WordLift`
   - **Integration URL:** `https://mcp.wordlift.io/sse`
5. **Save** and ensure the integration is enabled

### Step 2: Upload This Skill

1. **Zip this entire folder**
   ```bash
   cd /Users/cyberandy/Desktop
   zip -r wl-seo-audit-skill.zip wl-seo-audit-competitors/ -x "*.git*"
   ```

2. **Upload to Claude:**
   - Go to Claude Settings → Capabilities
   - Click "Upload Custom Skill"
   - Select the zip file
   - Wait for upload confirmation

3. **Enable in chats:**
   - When starting a new chat, enable the "wordlift-seo-audit" skill

### Step 3: Run Audits

Once both the MCP server and skill are configured, use prompts like:

```
"Audit https://myblackbriar.com/products/backpack vs top 5 competitors in the US market"

"Compare schema coverage with Italian competitors for https://example.com/product"

"Run a competitive SEO audit - check what structured data my competitors have"
```

## 🎯 What the Skill Does

### Workflow

1. **Detects audit requests** from user prompts
2. **Checks MCP availability** - guides setup if missing
3. **Calls WordLift:agent tool** with proper parameters
4. **Processes results** from the MCP server
5. **Generates rich reports** using REPORT_FORMAT.md guidelines

### Report Includes

- 📊 **Overall SEO Health Score** (0-100)
- 📈 **Six-Dimension Analysis** (Schema, Meta, Content, Technical, Mobile, Performance)
- 🔴 **Prioritized Issues** with actionable fixes
- 🏆 **Competitive Analysis** - what competitors are doing better
- 💡 **Growth Opportunities** - ranked by impact and effort
- ✅ **Schema Inventory** - what's implemented vs missing

## 🔧 Troubleshooting

### "Tool WordLift:agent not found"

**Cause:** MCP server not configured

**Fix:**
1. Go to Claude Settings → Integrations
2. Verify "WordLift" integration exists
3. Check that URL is: `https://mcp.wordlift.io/sse`
4. Enable the integration if disabled
5. Restart Claude if needed

### "Access denied" or 403 errors

**Cause:** Authentication issue with WordLift API

**Fix:**
1. Check WordLift MCP server documentation
2. Verify API key is configured in MCP server settings
3. Contact WordLift support for authentication help

### Skill doesn't trigger

**Cause:** Query doesn't match skill description

**Fix:** Use trigger keywords:
- "audit", "SEO", "schema", "competitors"
- Mention URLs to analyze
- Reference "structured data" or "Schema.org"

## 📚 Key Architecture Concept

### Why MCP is Required

**Agent Skills run in sandboxed environments with NO network access.**

- ❌ Cannot make HTTP requests directly
- ❌ Cannot call external APIs via curl/fetch
- ✅ CAN use MCP tools to access external services

### How It Works

```
User: "Audit this URL..."
↓
Claude reads SKILL.md (sandboxed environment)
↓
Claude calls: WordLift:agent tool
↓
MCP server makes HTTP request to WordLift API
↓
MCP returns data to Claude
↓
Claude formats report using REPORT_FORMAT.md
```

## 🎓 Important Concepts

### Agent Skills

- Provide **instructions and methodology** to Claude
- Run in **sandboxed environment** (no network access)
- Can execute local Python/bash scripts
- Use **progressive disclosure** (load files as needed)
- Reference MCP tools with fully qualified names

### MCP (Model Context Protocol)

- **External integrations** for Claude
- **Can make HTTP requests** and API calls
- Handle **authentication** securely
- Provide **tools** Claude can invoke
- Tools named as: `ServerName:tool_name`

### Progressive Disclosure

- **SKILL.md** always loaded when skill triggers
- **REPORT_FORMAT.md** loaded when Claude needs formatting help
- **Templates** available as reference
- Minimizes token usage - only load what's needed

## 📖 Additional Resources

- **Full docs:** See `docs/readme.md`
- **Report formatting:** See `REPORT_FORMAT.md`
- **Agent Skills guide:** https://docs.claude.com/en/docs/agents-and-tools/agent-skills/
- **MCP documentation:** https://docs.claude.com/en/docs/agents-and-tools/mcp-connector

## ✨ Next Steps

1. ✅ Configure WordLift MCP integration
2. ✅ Upload this skill as a zip file
3. ✅ Test with a sample URL audit
4. 📊 Review generated reports
5. 🎨 Customize REPORT_FORMAT.md if needed

---

**Ready to audit!** 🚀

Once setup is complete, Claude will automatically:
- Detect SEO audit requests
- Call WordLift MCP tools
- Generate comprehensive reports
- Provide actionable recommendations
