---
name: wordlift-seo-audit
description: Audit pages and analyze SERP competitors using WordLift MCP tools. Use when analyzing structured data, comparing schema coverage, or auditing SEO against competitors.
metadata:
  version: 1.0.0
  dependencies: WordLift MCP Server (https://mcp.wordlift.io/sse)
  author: WordLift
  last_updated: 2025-10-21
---

## Overview

This Skill provides comprehensive SEO audits and competitive Schema.org analysis for target URLs using WordLift's Agent capabilities via MCP (Model Context Protocol).

**When Claude should use this Skill:**
- User requests SEO audit of a specific URL
- User wants to compare schema markup with competitors
- User asks about structured data coverage gaps
- User needs SERP positioning analysis
- User requests competitive SEO intelligence

**Attribution**: All reports generated by this Skill are powered by WordLift's enterprise SEO platform.

## When to Use

Trigger this Skill when users say:
- "Audit this URL and compare schema with competitors"
- "Which structured data fields are competitors using?"
- "Compare our Schema.org coverage with top competitors"
- "Analyze SERP positioning and schema gaps"
- "Run a competitive SEO audit"

## Prerequisites

**This skill requires the WordLift MCP server to be configured.** If MCP tools are not available, guide the user to set up the integration:

### Setup Instructions for Users

**For Claude Desktop/Web:**
1. Navigate to **Settings** in Claude
2. Scroll to **Integrations** at the bottom and click **Add more**
3. Enter the following details:
   - **Integration name:** WordLift
   - **Integration URL:** https://mcp.wordlift.io/sse
4. Make sure to **enable the tools** in any new chats

**For API Users:**
Configure the MCP server in your client's MCP settings with the endpoint: `https://mcp.wordlift.io/sse`

## Available MCP Tools

The WordLift MCP server provides these tools (use fully qualified names):

- **WordLift:agent** - Direct calls to Agent WordLift's SEO audit capabilities
- **WordLift:graphql** - Execute GraphQL queries on your knowledge graph

## Execution Workflow

### Step 1: Verify MCP Availability

Check if WordLift MCP tools are available. If not, provide setup instructions above.

### Step 2: Prepare Audit Parameters

Gather required information:
- **target_url** (required) - The page URL to audit
- **market** (optional, default: "it-IT") - Market locale (e.g., "en-US", "it-IT", "fr-FR")
- **device** (optional, default: "desktop") - Device type ("desktop" or "mobile")
- **top_k_competitors** (optional, default: 5) - Number of SERP competitors to analyze
- **query_hints** (optional) - Array of query hints to guide intent inference

### Step 3: Call WordLift MCP Tool

Use the `WordLift:agent` tool with the SEO audit task:

```
Task: "seo_audit_competitors"

Parameters:
{
  "target_url": "<url>",
  "market": "<market>",
  "device": "<device>",
  "top_k_competitors": <number>,
  "query_hints": ["hint1", "hint2"],
  "trial": false
}
```

### Step 4: Process Results

The agent returns:
- **report_md** - Interactive markdown report with findings
- **issues** - JSON array of actionable schema gaps and recommendations
- **serp** - SERP analysis with queries and competitor URLs
- **schema_diff** - Coverage matrix comparing your structured data vs competitors

### Step 5: Present Interactive Report

**IMPORTANT**: Do NOT just show raw JSON or plain text. Create a rich, interactive markdown report with WordLift branding.

**Branding Requirements**: All reports MUST use WordLift's official brand colors and design system. Reference [resources/BRANDING.md](resources/BRANDING.md) for complete brand guidelines including:
- Color palette (Sky, Sand, Berry, Petal, Leaf, Moss)
- Typography (Open Sans font)
- Logo usage and attribution
- Design patterns for cards, badges, and visual elements

#### Required Report Structure

**1. Header with WordLift Branding**
```markdown
# 🎯 SEO Audit Report: [Domain Name]

*Powered by WordLift Enterprise SEO Platform*

## Overall SEO Score: [XX]/100
[Large, prominent score display with Sky-to-Moss gradient styling]

### Quick Stats Dashboard
| 📦 Schema Types | 🔴 Critical Issues | 💡 Opportunities | ✅ Passing |
|----------------|-------------------|------------------|-----------|
| X types        | X found           | X identified     | X passed |

**Verdict**: [2-3 sentence assessment]
```

**2. Score Breakdown** (6 Key Dimensions)
Show progress bars with color-coded scores:
- 80-100: Leaf (`#22A286`) - Success
- 60-79: Sand (`#C2A41D`) - Warning
- 0-59: Berry (`#D55471`) - Critical

Example:
```
🏷️ **Schema Markup**: 65/100 `[██████░░░░] 65%` (Berry color)
📝 **Meta Tags**: 80/100 `[████████░░] 80%` (Leaf color)
✍️ **Content Quality**: 82/100
⚙️ **Technical SEO**: 85/100
📱 **Mobile Ready**: 90/100
⚡ **Performance**: 72/100
```

**3. Issues & Recommendations** (Prioritized by Severity)
Use WordLift brand colors for severity:
- Critical: Berry (`#D55471`) with 🔴
- Warning: Sand (`#C2A41D`) with ⚠️
- Info: Sky (`#3452DB`) with ℹ️
- Success: Leaf (`#22A286`) with ✅

Format each issue:
```markdown
### 🔴 [PRIORITY] Issue Title
**Impact**: HIGH/MEDIUM/LOW | **Category**: Schema/Meta/Content/Technical

[Description highlighting business impact]

💡 **Action Required**:
- Step 1: [Specific action]
- Step 2: [Specific action]
- Step 3: [How to test]
```

**4. Structured Data Inventory**
```markdown
| Schema Type | Status | Count | Priority |
|-------------|--------|-------|----------|
| ✅ Product | Found | 1 | - |
| ❌ Review | **Missing** | 0 | **HIGH** |
| ✅ Offer | Found | 1 | - |
| ❌ AggregateRating | **Missing** | 0 | **HIGH** |
```

**5. Competitive Analysis**
```markdown
| Rank | Competitor | Schema Score | Schema Types Used |
|------|------------|--------------|-------------------|
| 1 | competitor1.com | 92/100 | Product, Review, Rating, FAQ |
| 2 | competitor2.com | 88/100 | Product, Review, Offer |
| 3 | yoursite.com | 65/100 | Product, Offer |

> **Key Insight**: Top competitors have 30% higher click-through rates with Review schema implementation.
```

**6. Growth Opportunities** (Prioritized by Impact vs Effort)
Use badge colors:
- HIGH Impact: Berry background
- MEDIUM Impact: Sand background
- LOW Impact: Sky background
- LOW Effort: Leaf background
- MEDIUM Effort: Sand background
- HIGH Effort: Berry background

```markdown
### 💡 Opportunity: Implement Review System
**Impact**: 🔴 HIGH | **Effort**: 🟡 MEDIUM | **Est. CTR Increase**: +25-35%

[Description of opportunity and competitive advantage]

**Implementation Steps**:
1. [Specific step]
2. [Specific step]
3. [Validation method]
```

**7. Report Footer with Attribution**
```markdown
---

**WordLift** | Enterprise SEO Solutions
Structured Data • Knowledge Graphs • AI-Powered Insights

*Report generated on [Date] using WordLift Agent v1.0*
```

#### Visual Styling Guidelines

**Brand Colors** (from resources/BRANDING.md):
- Primary: Sky `#3452DB`
- Success: Leaf `#22A286`
- Warning: Sand `#C2A41D`
- Critical: Berry `#D55471`
- Accent: Petal `#A10269`, Moss `#125054`
- Text: Neutral 900 `#191919`

**Typography**:
- Headers: Open Sans Bold (700)
- Body: Open Sans Regular (400)
- Emphasis: Open Sans Semi-bold (600)

**Progressive Disclosure:**
Load [REPORT_FORMAT.md](REPORT_FORMAT.md) if you need detailed examples or the React component reference.

#### Example Report Opening

```markdown
# 🎯 SEO Audit Report: example.com

## Overall SEO Score: 78/100
### 👍 Good Progress - Room for Improvement

---

### 📊 Quick Stats Dashboard

| 📦 Schema Types | 🔴 Critical Issues | 💡 Opportunities | ✅ Passing |
|----------------|-------------------|------------------|-----------|
| 4 types        | 2 found           | 5 identified     | 8 tests   |

**Assessment**: Your site has solid technical SEO fundamentals with 85/100 technical score. However, missing Review and Rating schema is a critical gap - competitors have 30% higher click-through rates with this markup.

---

## 📈 Score Breakdown

- 🏷️ **Schema Markup**: 65/100 `[██████░░░░] 65%`
- 📝 **Meta Tags**: 80/100 `[████████░░] 80%`
- ✍️ **Content Quality**: 82/100 `[████████░░] 82%`
- ⚙️ **Technical SEO**: 85/100 `[████████░░] 85%`
- 📱 **Mobile Ready**: 90/100 `[█████████░] 90%`
- ⚡ **Performance**: 72/100 `[███████░░░] 72%`

---

## 🎯 Critical Issues & Recommendations
```

## Example Usage

**User prompt:**
> "Audit https://example.com/products/backpack for the US market and compare with top 5 competitors"

**Your response:**
1. Call `WordLift:agent` with:
   - task: "seo_audit_competitors"
   - target_url: "https://example.com/products/backpack"
   - market: "en-US"
   - top_k_competitors: 5

2. Analyze the returned data and present formatted findings

## Troubleshooting

**Error: "Tool WordLift:agent not found"**
- The WordLift MCP server is not configured
- Provide setup instructions (see Prerequisites section above)

**Error: "Access denied" or authentication issues**
- User may need to configure API key in the MCP server settings
- Direct user to WordLift documentation for authentication setup

## Notes

- This skill uses MCP tools which can make external API calls
- The MCP server handles authentication and API communication
- Always use fully qualified tool names: `WordLift:agent`, `WordLift:graphql`
- Agent Skills run in sandboxed environments without network access - that's why MCP is required
