# WordLift Brand Guidelines

**Version**: 1.0.0
**Last Updated**: October 2025

This document defines WordLift's official brand identity for use in all SEO audit reports and visual outputs generated by this Skill.

---

## Brand Colors

### Primary Brand Color

**Sky** - `#3452DB` - `rgb(52, 82, 219)`
- Primary brand color
- Use for headers, primary CTAs, and key highlights
- Creates trust and professionalism

### Accent Colors

| Color | Hex | RGB | Usage |
|-------|-----|-----|-------|
| **Sand** | `#C2A41D` | `rgb(194, 164, 29)` | Highlights, warnings, medium-priority items |
| **Berry** | `#D55471` | `rgb(213, 84, 113)` | Attention, critical issues, alerts |
| **Petal** | `#A10269` | `rgb(161, 2, 105)` | Secondary accent, action items |
| **Leaf** | `#22A286` | `rgb(34, 162, 134)` | Success states, positive metrics, passing tests |
| **Moss** | `#125054` | `rgb(18, 80, 84)` | Deep accent, secondary headings |

### Neutral Palette

| Color | Hex | RGB | Usage |
|-------|-----|-----|-------|
| **Neutral 900** | `#191919` | `rgb(25, 25, 25)` | Primary text, body copy |
| **Neutral 500** | `#A1A7AF` | `rgb(161, 167, 175)` | Secondary text, captions, metadata |
| **Neutral 100** | `#F6F6F7` | `rgb(246, 246, 247)` | Light backgrounds, card backgrounds |
| **White** | `#FFFFFF` | `rgb(255, 255, 255)` | Primary backgrounds, cards |

---

## Typography

### Primary Font: Open Sans

**Source**: Google Fonts - `https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap`

**Available Weights**:
- **300** - Light (use sparingly for large headings)
- **400** - Regular (body text, paragraphs)
- **600** - Semi-bold (subheadings, emphasis)
- **700** - Bold (primary headings, important metrics)

### Typography Hierarchy

```
H1: 32-36pt, Open Sans Bold (700), color: Neutral 900
H2: 24-28pt, Open Sans Semi-bold (600), color: Moss (#125054)
H3: 18-20pt, Open Sans Semi-bold (600), color: Berry (#D55471)
Body: 14-16pt, Open Sans Regular (400), color: Neutral 900
Caption: 12-14pt, Open Sans Regular (400), color: Neutral 500
```

---

## Logo Usage

### WordLift Logos

**Square Logo**:
```
https://wordlift.io/wp-content/uploads/2024/01/wordlift-square-logo.png
```

**Horizontal Logo**:
```
https://upload.wikimedia.org/wikipedia/commons/4/48/WordLift-logo-horizontal-2024.png
```

### Logo Guidelines

- Always maintain aspect ratio (no stretching)
- Minimum clear space: 0.5 inches (12mm) around all sides
- On light backgrounds: Use full-color logo
- On dark backgrounds: Use white logo or inverted version
- Never rotate, distort, or add effects to the logo

### Text-Based Logo Fallback

When images cannot be loaded, use this text representation:

```
Word in White (#FFFFFF) + Lift in Sand (#C2A41D)
Font: Open Sans Bold (700)
Letter-spacing: -1px
```

---

## Design System

### Background Patterns

**Primary Backgrounds**:
```css
background: linear-gradient(135deg, #3452DB 0%, #125054 100%);
/* Sky to Moss gradient - use for hero sections and headers */
```

**Card Backgrounds**:
```css
background: #FFFFFF;
border: 3px solid #3452DB;
border-radius: 12px;
box-shadow: 0 10px 40px rgba(0,0,0,0.1);
```

### Color Hierarchy for Headings

1. **Primary Headings**: Neutral 900 (`#191919`)
2. **Section Headings**: Moss (`#125054`)
3. **Subsection Headings**: Berry (`#D55471`)
4. **Emphasis Text**: Sky (`#3452DB`)

### Metric Cards

```css
background: linear-gradient(135deg, Sky → Moss);
color: White;
padding: 50px 40px;
border-radius: 12px;
border: 4px solid Sky;
box-shadow: 0 15px 50px rgba(0,0,0,0.2);
```

### Action Items & Recommendations

```css
background: rgba(Petal, 0.1); /* Light Petal background */
border-left: 4px solid Petal;
padding: 20px;
border-radius: 10px;
```

### Issue Severity Colors

| Severity | Color | Icon | Usage |
|----------|-------|------|-------|
| **Critical** | Berry (`#D55471`) | 🔴 | Critical issues requiring immediate action |
| **Warning** | Sand (`#C2A41D`) | ⚠️ | Important issues to address soon |
| **Info** | Sky (`#3452DB`) | ℹ️ | Informational items |
| **Success** | Leaf (`#22A286`) | ✅ | Passing tests, positive outcomes |

### Impact & Effort Badges

**Impact Badges**:
- HIGH: Berry background, white text
- MEDIUM: Sand background, white text
- LOW: Sky background, white text

**Effort Badges**:
- LOW: Leaf background, white text (easy to implement)
- MEDIUM: Sand background, white text
- HIGH: Berry background, white text (complex to implement)

---

## Report Attribution

Every report must include WordLift branding:

### Header Attribution

```markdown
# 🎯 SEO Audit Report

*Powered by WordLift Enterprise SEO Platform*
```

### Footer Attribution

```markdown
---

**WordLift** | Enterprise SEO Solutions
Structured Data • Knowledge Graphs • AI-Powered Insights
```

---

## Usage in Reports

### Example Color Application

**Score Display**:
- Background: Linear gradient (Sky → Moss)
- Score text: White
- Border: Sky

**Critical Issues**:
- Border: Berry
- Icon: 🔴
- Badge background: Berry

**Success Items**:
- Border: Leaf
- Icon: ✅
- Badge background: Leaf

**Action Required Sections**:
- Background: Light Petal (rgba)
- Border-left: Petal
- Heading color: Neutral 900

### Progress Bars

```
Color based on score:
- 80-100: Leaf (#22A286) - Success
- 60-79: Sand (#C2A41D) - Warning
- 0-59: Berry (#D55471) - Critical
```

---

## Accessibility

All color combinations must meet WCAG 2.1 AA standards:

- **Primary text on white**: Neutral 900 (excellent contrast)
- **White text on Sky**: Pass (contrast ratio 4.8:1)
- **White text on Moss**: Pass (contrast ratio 7.2:1)
- **White text on Berry**: Pass (contrast ratio 4.6:1)

**Never use**:
- Sand text on white backgrounds (poor contrast)
- Neutral 500 for important text (use for metadata only)

---

## Examples

### SEO Score Card

```markdown
<div style="background: linear-gradient(135deg, #3452DB 0%, #125054 100%);
            color: #FFFFFF;
            padding: 50px;
            border-radius: 12px;
            text-align: center;">
  <h1 style="font-size: 6em; font-weight: 700;">85</h1>
  <p>SEO Health Score</p>
</div>
```

### Issue Card

```markdown
<div style="background: #F6F6F7;
            border-left: 5px solid #D55471;
            padding: 25px;
            border-radius: 10px;">
  🔴 <strong>Critical Issue</strong>
  <span style="background: #D55471;
               color: #FFFFFF;
               padding: 4px 12px;
               border-radius: 12px;">HIGH IMPACT</span>
  <p style="color: #191919;">Missing Review schema reduces CTR by 25%</p>
</div>
```

---

## Version History

- **1.0.0** (October 2025) - Initial brand guidelines for SEO Audit Skill
